/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.startup;

import com.ibm.hwmca.base.util.SimServer;
import com.ibm.hwmca.fw.connmgr.ConnectionFactory;
import com.ibm.hwmca.fw.log.E4EventLog;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.servlet.login.BobcatHmcPrincipal;
import com.ibm.hwmca.fw.servlet.pmod.task.PanelModelTaskPortal;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.servlet.util.ServletRuntime;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.system.StartupApp;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.task.TaskLauncher;
import com.ibm.hwmca.fw.tomcat.HmcFormAuthenticator;
import com.ibm.hwmca.fw.tomcat.HmcPrincipal;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class PreLogonServlet
extends HttpServlet {
    private static final String TRACE_MASKT = "XSRVSTAT";
    private static final String TRACE_MASKF = "XSRVSTAF";
    private static final String TRACE_MASKD = "XSRVSTAD";
    private StartupApp startupTask;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block12: {
            Trace.trace(TRACE_MASKT, "-> PreLogonServlet.doGet");
            response.setHeader("Cache-Control", "no-cache");
            try {
                String key;
                Object[] pageSubst = new String[]{HMC.getTitle()};
                ServletRuntime.getRuntime().attachUserContextToServletThread(request);
                HttpSession httpSession = request.getSession();
                ResourceBundle bundle = ResourceBundle.getBundle("com.ibm.hwmca.fw.servlet.startup.res.PreLogonServlet");
                String step = request.getParameter("step");
                if ("task".equals(step)) {
                    Trace.trace(TRACE_MASKF, "Trying to start StartupApp task");
                    Trace.trace(TRACE_MASKD, "Session class name is: " + httpSession.getClass().getName());
                    HMCSession hmcSession = HMCSession.getHMCSession(httpSession);
                    PresentationTaskParms parms = new PresentationTaskParms(null);
                    parms.setData("redirectURL", request.getContextPath() + "/preLogon?step=autologon");
                    this.startupTask = (StartupApp)TaskLauncher.startTask(parms, "com.ibm.hwmca.fw.system.StartupApp", hmcSession, false);
                    PanelModelTaskPortal portal = this.startupTask.getPanelModelTaskPortal();
                    Trace.trace(TRACE_MASKF, "Started StartupApp Task.. waiting for panel");
                    portal.waitForPanel();
                    if (portal.isTaskEnded()) {
                        Trace.trace(TRACE_MASKD, "PreLogonServlet: the task ended before we redirected");
                    } else {
                        Trace.trace(TRACE_MASKF, "Done waiting for panel. Enabling refreshes and redirecting: taskId=" + this.startupTask.getTaskId());
                        portal.setRefreshEnabled(true);
                        response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/content?taskId=" + this.startupTask.getTaskId()));
                    }
                    break block12;
                }
                if ("autologon".equals(step)) {
                    Trace.trace(TRACE_MASKT, "PreLogonServlet: performing autologon");
                    PreLogonServlet preLogonServlet = this;
                    Object[] logonData = preLogonServlet.startupTask.getAutoLogonData();
                    response.setContentType("text/html");
                    PrintWriter out = response.getWriter();
                    Object url = null;
                    if (logonData[0] != null && logonData[1] != null) {
                        HMCSession hmcSession;
                        Object principal;
                        Trace.trace(TRACE_MASKD, "PreLogonServlet: autologon enabled.. authenticating.");
                        boolean runningBobcat = System.getProperty("RUNNING_BOBCAT", "false").equalsIgnoreCase("true");
                        if (runningBobcat) {
                            ConnectionFactory connFactory = new ConnectionFactory(CommonSystem.getCommonSystem().getManagerHost(), 9940);
                            connFactory.setUserAndPassword((String)logonData[0], (byte[])logonData[1]);
                            principal = new BobcatHmcPrincipal((String)logonData[0], connFactory);
                            httpSession.setAttribute("PRINCIPAL", principal);
                            hmcSession = HMCSession.getHMCSession(httpSession);
                            ClientUserContext userContext = new ClientUserContext(((BobcatHmcPrincipal)principal).getConnectionFactory());
                            ServletRuntime.getRuntime().updateUserContext(userContext, request);
                            hmcSession.setUserContext(userContext);
                            userContext.attachToThread(true);
                        } else {
                            HmcFormAuthenticator formAuth = HmcFormAuthenticator.getHmcFormAuthenticator();
                            principal = (HmcPrincipal)((Object)formAuth.authenticate((String)logonData[0], (byte[])logonData[1], httpSession));
                            hmcSession = HMCSession.getHMCSession(httpSession);
                            ClientUserContext userContext = new ClientUserContext(((HmcPrincipal)((Object)principal)).getConnectionFactory());
                            ServletRuntime.getRuntime().updateUserContext(userContext, request);
                            hmcSession.setUserContext(userContext);
                            userContext.attachToThread(true);
                        }
                        String[] subst = new String[]{(String)logonData[0]};
                        FrameworkEventText fet = new FrameworkEventText(687, subst);
                        new SystemEventLog(fet, "AUTOLOG").log();
                        new E4EventLog(fet, "AUTOLOG").log();
                        String page = MessageFormat.format(bundle.getString("redirect_page_with_autologon"), pageSubst);
                        out.write(page);
                    } else {
                        Trace.trace(TRACE_MASKD, "PreLogonServlet: no autologon.. invalidating session");
                        HMCSession hmcSession = HMCSession.getHMCSession(httpSession);
                        hmcSession.destroy();
                        String page = MessageFormat.format(bundle.getString("redirect_page"), pageSubst);
                        out.write(page);
                    }
                    break block12;
                }
                Trace.trace(TRACE_MASKF, "PreLogonServlet: initializing web app");
                ServletRuntime.getRuntime();
                ServletRuntime.initializeWebApplication(request, this.getServletContext());
                response.setContentType("text/html");
                PrintWriter out = response.getWriter();
                try {
                    byte[] xcpxStatus = SimServer.getSimServer().readSim(5);
                    key = xcpxStatus[0] == 1 ? "prelogon_page_data_se" : (xcpxStatus[0] == 5 ? "prelogon_page_data_tke" : "prelogon_page_data");
                }
                catch (Exception e) {
                    key = "prelogon_page_data";
                }
                String page = MessageFormat.format(bundle.getString(key), pageSubst);
                Trace.trace(TRACE_MASKF, "PreLogonServlet: printing frameset");
                out.print(page);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, e);
                throw new ServletException((Throwable)e);
            }
        }
        Trace.trace(TRACE_MASKT, "<- PreLogonServlet.doGet");
    }
}

